PROGRAM SWNT_band_structure

!Calculates electronic band structure
!of any (n,m) Single-Wall Carbon NanoTube
!Based on a simple pz-orbital tight binding model
!P. Hirel, Y. Giret 2004

IMPLICIT NONE
INTEGER :: ndirection, number_of_kpoints, ixyz, i, l
INTEGER, PARAMETER :: npoint=60 ! number of divisions along direction
REAL*8 :: factor, fact1, fact2, fact3, fact4, fact5, fact6, m, m1, mn, &
&         mn2, n, n1, norm, pgcd, pi,step
REAL*8, PARAMETER :: epsilon=0.d0 
REAL*8, PARAMETER :: gamma=-2.5d0 
REAL*8, PARAMETER :: s=0.0d0 
REAL*8, PARAMETER :: a=2.46d0  ! lattice parameter in A
REAL*8 :: a1(3) ! first lattice vector for graphene plane
REAL*8 :: a2(3) ! second lattice vector for graphene plane 
REAL*8 :: aperp(3)  ! perpendicular lattice vector of the nanotube
REAL*8 :: aparr(3)  ! parallel lattice vector of the nanotube
REAL*8 :: b1(3) ! first reciprocal vector for graphene plane
REAL*8 :: b2(3) ! second reciprocal vector for graphene plane
REAL*8 :: kpt(3)
REAL*8 :: bperp(3) ! reciprocal perpendicular lattice vector of the nanotube
REAL*8 :: bparr(3) ! reciprocal parallel lattice vector of the nanotube
REAL*8 :: Gamma_point(3)
REAL*8 :: M_point(3)
REAL*8 :: bdir(3)
REAL*8, DIMENSION(:), ALLOCATABLE :: norme
REAL*8, DIMENSION(:,:), ALLOCATABLE :: kpt_bs

!=============================================================
! Definition of lattice vectors
!=============================================================

PRINT*,'epsilon=', epsilon
PRINT*,'gamma=', gamma
PRINT*,'s=', s


a1(:)=0.d0
a1(1)=a*DSQRT(3.d0)/2.d0
a1(2)=-a/2.d0

a2(:)=0.d0
a2(1)=a*DSQRT(3.d0)/2.d0
a2(2)=a/2.d0

write(6,*) 'Enter n'
read(5,*) n
write(6,*) 'Enter m'
read(5,*) m

n1 = 2.d0*n + m
m1 = 2.d0*m + n

! Finding the highest common divisor

 DO WHILE (n1/=m1)
  mn = MAX(n1, m1)
  mn2 = mn - MIN(n1, m1)
  n1 = MIN(n1, m1)
  m1 = mn2
 END DO

pgcd = n1
  
aperp(:) = n*a1(:) + m*a2(:)
aparr(:) = ((2.d0*m+n)/pgcd)*a1(:) - ((2.d0*n+m)/pgcd)*a2(:)


!=============================================================
! Definition of reciprocal vectors
!=============================================================

PRINT*,'lattice parameter is equal to', a
pi=4.d0*ATAN(1.d0)
PRINT*,'pi=', pi
factor=(pi/(a*(n*n+m*m+m*n)))

bperp(:)=0.d0
bperp(1)=factor*DSQRT(3.d0)*(m+n)
bperp(2)=factor*(m-n)

bparr(:)=0.d0
bparr(1)=factor*pgcd*(m-n)/DSQRT(3.d0)
bparr(2)=-factor*pgcd*(m+n)

Gamma_point(:)=0.d0

!=============================================================
! Definition of directions in reciprocal space
!=============================================================

norm = DSQRT(DOT_PRODUCT(bparr, bparr)) ! norm of bparr
bdir(:) = bparr(:)/norm ! unit vector along bparr direction

step = norm/REAL(npoint-1) 
number_of_kpoints=npoint


!=============================================================
! Definition of the k vector along the direction of the nanotube
!=============================================================

ALLOCATE(norme(number_of_kpoints))
ALLOCATE(kpt_bs(3,(number_of_kpoints)))
norme(:)=0.d0

 DO i=1, number_of_kpoints
   norme(i) = REAL(i-1)*step 
   kpt_bs(:, i) = norme(i)*bdir(:)
   PRINT*,'kpt(', i, ')=', (kpt_bs(ixyz, i), ixyz=1, 3)
 END DO


!=============================================================
! Writing data in file NT_BAND_STRUCTURE 
!=============================================================

fact1 = (2.d0*n+m)*pi/(m*m+n*n+m*n)
fact2 = (2.d0*m+n)*pi/(m*m+n*n+m*n)
fact3 = m*a*DSQRT(3.d0)/(2.d0*DSQRT(m*m+n*n+m*n))
fact4 = -n*a*DSQRT(3.d0)/((2.d0*DSQRT(m*m+n*n+m*n)))
fact5 = (n-m)*pi/(m*m+n*n+m*n)
fact6 = (m+n)*a*DSQRT(3.d0)/((2.d0*DSQRT(m*m+n*n+m*n)))

OPEN(UNIT=300,FILE='NT_BAND_STRUCTURE.dat',STATUS='UNKNOWN',&
&    FORM='FORMATTED')

 DO l=1, n
      DO i = 1, number_of_kpoints
         PRINT*,'i=', i
         WRITE(300,*) norme(i), &
&                     (epsilon+gamma*DSQRT(DABS(3.d0 &
&          +2.d0*DCOS(fact1*l+fact3*norme(i))&
&          +2.d0*DCOS(fact2*l+fact4*norme(i))&
&          +2.d0*DCOS(fact5*l+fact6*norme(i))))),&
&                     (epsilon-gamma*DSQRT(DABS(3.d0 &
&          +2.d0*DCOS(fact1*l+fact3*norme(i))&
&          +2.d0*DCOS(fact2*l+fact4*norme(i))&
&          +2.d0*DCOS(fact5*l+fact6*norme(i)))))
          WRITE(300,*) (-norme(i)), &
&                     (epsilon+gamma*DSQRT(DABS(3.d0 &
&          +2.d0*DCOS(fact1*l+fact3*norme(i))&
&          +2.d0*DCOS(fact2*l+fact4*norme(i))&
&          +2.d0*DCOS(fact5*l+fact6*norme(i))))),&
&                     (epsilon-gamma*DSQRT(DABS(3.d0 &
&          +2.d0*DCOS(fact1*l+fact3*norme(i))&
&          +2.d0*DCOS(fact2*l+fact4*norme(i))&
&          +2.d0*DCOS(fact5*l+fact6*norme(i)))))
      END DO
 END DO

 CLOSE(UNIT=300)

 PRINT*,'norm', norm, '; pi/a*sqrt3 =', pi/(a*DSQRT(3.d0)), &
&       '; pi/apar =', pi/DSQRT(DOT_PRODUCT(aparr, aparr))


 DEALLOCATE(norme)
 DEALLOCATE(kpt_bs)


END PROGRAM SWNT_band_structure
